"use strict";

/**
 * [HTSDK扩展对象]
 */
var HTSDK = window.HTSDK || {};

/**!
 * Dependent on HuanTuo JS-SDK Library v1.0.2
 * http://www.talk-fun.com/
 * 
 * @copyright: [2016, Huantuo]
 * @version: [v2.0.1]
 * @author: [Marko, Yj, Xin]
 * @description: [欢拓SDK-命令接收]
 * @API: http://open.talk-fun.com/open/doc/sdk.js.html
 * @模版采用Tmod模版
 */

// cmd执行
HTSDK.cmd = function(){
	/**
	 * [_HT 实例化SDK]
	 * @param {[String]} [access_token] [房间验证密钥]
	 * @type  {Object}
	 */
	var _HT = new MT.SDK.main(access_token);

	/**
	 * [HTSDK扩展对象]
	 */
	var HTSDK = window.HTSDK || {};


	// log
	var log = function(){
		if(window.console && window.console.info){
			for (var i = 0; i < arguments.length; i++) {
				//console.info(arguments[i]);
			};
		}
	};

	// 内置方法
	// 初始化
	_HT.on("core:initdata", function(data){
		MTSDK.admin.adminBox.pptPreView(data.step2, function(retval){
			// TODO...
			HTSDK.footer.pptPreView(retval);
		});
	});

	// 翻页
	_HT.on("core:whiteboard", function(whiteboard){
		MTSDK.admin.adminBox.pptPreView(whiteboard, function(retval){
			// TODO..
			HTSDK.footer.pptPreView(retval);
		});
	});

	/**
	 * 服务器连接部分
	 */
	// 连接成功
	_HT.on("connect", function(retval){
		$("#logs").append('<p>服务器连接成功...</p>');
	});
	// 连接失败
	_HT.on("connect_failed", function(retval){
		$("#logs").append('<p>服务器连接失败...</p>');
	});
	// 连接错误
	_HT.on("connect_error", function(retval){
		$("#logs").append('<p>服务器连接错误...</p>');
	});

	/**
	 * ==== SDK调用部分 ====
	 */

	// 聊天
	_HT.on("chat:send", function(retval){
		HTSDK.modChat.onChat(retval);
	});

	// 鲜花初始化
	_HT.on("flower:get:init", function(retval){
		HTSDK.plugins.flower.flowerInit(retval);
	});

	// 送花成功
	_HT.on("flower:send", function(retval){
		HTSDK.plugins.flower.sendCallback(retval);
	});

	// 鲜花总数
	_HT.on("flower:total", function(flower){
		HTSDK.plugins.flower.autoIncrease(flower);
	});

	// 获取第一朵鲜花时间
	_HT.on("flower:time:left", function(sec){
		HTSDK.plugins.flower.flowerTimeleft(sec);
	});

	// 开始抽奖
	_HT.on("lottery:start", function(retval){
		setTimeout(function(){
			HTSDK.plugins.lottery.startLottery(retval);
		}, 3000);
	});

	// 结束抽奖
	_HT.on("lottery:stop", function(retval){
		setTimeout(function(){
			HTSDK.plugins.lottery.stopLottery(retval);
		}, 3000);
	});

	// 公告
	_HT.on("announce:notice", function(retval){
		HTSDK.modSider.notify(retval);
	});
	
	//广播
	_HT.on("broadcast", function(retval){
		HTSDK.plugins.diyBroadcast(retval);
	});

	// 滚动通知
	_HT.on("announce:roll", function(retval){
		HTSDK.plugins.rollNotice(retval);
	});

	// 在线用户人数
	_HT.on('member:total', function(total){
		HTSDK.modOnlines.total(total);
	});

	// 特殊用户
	_HT.on("live:robots:users", function (list) {
		if(list && list.length > 0){
			list = list;
		}else{
			list = [];
		}
		HTSDK.modOnlines.robot = list;
	});

	// 广播设置特殊用户
	_HT.on("member:robots", function (list) {
		if(list && list.robots.length > 0){
			list = list;
		}else{
			list = [];
		}
		HTSDK.modOnlines.broadcastSetRobot(list.robots);
	});
	// 在线用户列表
	_HT.on("member:list", function(list){
		HTSDK.modOnlines.init(list);
	});

	// 用户加入
	_HT.on('member:join:other', function(retval){
		HTSDK.modOnlines.memberJoin(retval);
	});

	// 用户离开
	_HT.on('member:leave', function(user){
		HTSDK.modOnlines.memberLeave(user);
	});

	// 提问
	_HT.on("question:ask", function(retval){
		HTSDK.modQuestion.ask(retval);
	});

	// 回答
	_HT.on("question:reply", function(retval){
		HTSDK.modQuestion.reply(retval);
	});

	// 发起投票
	_HT.on("vote:new", function(retval){
		HTSDK.plugins.vote.showVote(retval);
	});

	// 公布投票结果
	_HT.on("vote:pub", function(retval){
		HTSDK.plugins.vote.showResult(retval);
	});

	// 强制退出
	_HT.on('member:forceout', function(retval){
		if(MT.me.xid === retval.xid){
			if(MT.me.sessionid === retval.sessionid){
	    		window.location.href = 'http://open.talk-fun.com/error.html?var=3';
			}
		}
	});

	// 踢出房间
	_HT.on('member:kick', function(retval){
		if(MT.me.xid === retval.xid){
            window.location.href = 'http://open.talk-fun.com/error.html?var=4';
            return;
		}
		HTSDK.modOnlines.memberkick(retval);
	});

	// 禁止聊天
	_HT.on('chat:disable',function(retval){
		HTSDK.modOnlines.chatAccess("chat:disable", retval);
	});

	//小班模式
	_HT.on("room:mode:type", function(type){
		HTSDK.oneToOne.init(type);
	});

	/**
	 * ==== 小班模式 ====
	 */
	if(_HT.livePlayer){
		// 初始化播放器
		// @mainPlayer(@容器ID, @播放器ID, @回调函数)
		_HT.livePlayer("mod_live_camera", "ht_live_player", function(player){
			HTSDK.oneToOne.playerInit(player);
		});

		// 小班初始化数据
		_HT.on("usercamera:init", function(retval){
			HTSDK.oneToOne.defaults.oneStatus = retval.status;
			HTSDK.oneToOne.defaults.dataObject = retval.applyList;
			HTSDK.oneToOne.initStatus(retval);
		});

		// 教师开启摄像头
		_HT.on("usercamera:start", function(retval){
			HTSDK.oneToOne.cameraStart();
		});

		// 教师关闭摄像头
		_HT.on("usercamera:stop", function(retval){
			HTSDK.oneToOne.cameraStop();
		});


		// 教师允某人上讲台
		_HT.on("usercamera:up", function(retval){
			HTSDK.oneToOne.allowUp(retval.xid,retval.nickname);
		});

		// 教师踢除某人
		_HT.on("usercamera:kick", function(retval){
			HTSDK.oneToOne.kickStu(retval.xid, retval.nickname);
		});

		//推流是否成功
		_HT.on('usercamera:push:state', function(retval) {
			
		});

		//用户摄像头打开成功
		_HT.on('usercamera:open:camera:state', function(retval) {
			HTSDK.oneToOne.operCameraState(retval);
		});

		// 学生申请上
		_HT.on("usercamera:apply", function(retval){
			HTSDK.oneToOne.stuApply(retval.xid, retval.nickname);
		});

		// 学生主动下
		_HT.on("usercamera:down", function(retval){
			//console.info(retval);
			HTSDK.oneToOne.stuDown(retval.xid, retval.nickname);
		});

		// 学生自行取消
		_HT.on("usercamera:cancel", function(retval){
			HTSDK.oneToOne.stuCancel(retval.xid, retval.nickname);
		});
	}



	// * 创建主播播放器(大播放器)
	// * @mainPlayer(@容器ID, @播放器ID, @回调函数)
	_HT.mainPlayer("mod_main_player", "maituoPlayer", function(player){
			
			HTSDK.oneToOne.defaults.mainPlayer = player;

			HTSDK.player.setPlayer(player,function(){
				HTSDK.oneToOne.voiceHide();
			});
	});

	 // * 创建摄像头
	 // * @camera(@容器ID, @播放器ID, @回调函数)
	_HT.camera("mod_camera_player", "mtAuthorPlayer", function(camera){
			HTSDK.player.setCamera(camera);
	});

	// 直播开始
	_HT.on("live:start", function(title){
		HTSDK.room.liveChange("start", title);
	});

	// 直播停止
	_HT.on("live:stop", function(){
		HTSDK.room.liveChange("stop");
	});

	// 直播未开始
	_HT.on("live:wait",function(){
		HTSDK.room.liveChange("wait");
	});

	//网络状态 
	_HT.on("network:status",function(status){
		HTSDK.room.networkStatus(status);
	});

	// 模式切换
	_HT.on("live:mode:change",function(mode){
		// console.info(msg);
	});

	//课程信息
	_HT.on("live:course",function(msg){
		HTSDK.room.courseMsg = msg;
	});


	//房间模块设置
	_HT.on("live:room:modules",function(msg){
		HTSDK.room.roomSetMsg = msg;
	});

	// 课程过期
	_HT.on("course:expire",function(msg){
		//HTSDK.room.instructionBroadcast(msg);
		// console.info(msg);
	});

	// 课程进入错误
	_HT.on("live:course:access:error",function(msg){
		// console.info(msg);
	});

	// 房间配置
	_HT.on("live:room:configs", function(configs){
		// todo...
	});

	// 摄像头开启
	_HT.on("camera:start", function(){
		HTSDK.player.cameraLayer(true);
	});

	// 摄像头关闭
	_HT.on("camera:stop", function(){
		HTSDK.player.cameraLayer(false);
	});

	/**
	 * Start ====== Voice Of HT.VoiceCloud =======
	 * @语音模块
	 * 4种模式切换 & 监听
	 */
	
	// 房间语音模式
	_HT.on("room:mode", function(type){
		// 语音模块
        HTSDK.voice.init(type);
	});
	
	// [voice]改变用户语音权限
	_HT.on("member:voice:power", function(xid, power){
		HTSDK.voice.setVoicePower(xid, power);
	});

	// 谁在说话
	_HT.on("voice:speaking:user", function(user){
		// HTSDK.voice.whoSpeaking(user);
	});

	// 正在说话列表
	_HT.on("voice:speaking:list", function(list){
		HTSDK.voice.whoSpeaking(list);
	});
	
	// 语音云启动成功
	_HT.on("voice:connect:success", function(){
		// alert("...语音云链接成功...");
		HTSDK.voice.vCloudDone();
	});

	// 未开启或中断
	_HT.on("voice:disconnent", function(){
		//alert("语音云:中途断开或失败");
		HTSDK.voice.steps();
	});

	// 语音云音量
	_HT.on("voice:power", function(power){
		$("#voice_power em").css("width", power+"%");
	});

	// 语音云未启动
	_HT.on("voice:unlaunch", function(flag, times){
		HTSDK.voice.steps(flag, times);
	});

	// 模式切换监听
	_HT.on("voice:mode:change", function(data){
		var voiceType = data.mode;
		HTSDK.voice.switchVoiceMode(voiceType);
	});

	// [+voice]语音模式初始化
	_HT.on("voice:model:init", function(model){
		var voiceType = model;
		HTSDK.voice.switchVoiceMode(voiceType);
	});

	/**
	 * @获取语音云音量
	 * voice:volume:output  :输出设备音量
	 * voice:volume:input   :输入设备音量
	 */
	_HT.on("voice:volume:output", function(volume){
		HTSDK.voice.setVolume("output", volume);
	});

	_HT.on("voice:volume:input", function(volume){
		HTSDK.voice.setVolume("input", volume);
	});


	/**
	 * @语音权限控制
	 * voice:power:forbid  :禁止语音说话
	 * voice:power:allow   :允许语音说话
	 */
	_HT.on("voice:power:forbid", function(user){
		// 禁止语音说话
		HTSDK.voice.voiceGlobal.forbidVoice(user.data);
	});

	_HT.on("voice:power:allow", function(user){
		// 允许语音说话
		HTSDK.voice.voiceGlobal.allowVoice(user.data);
	});

	/**
	 * @主席模式
	 * voice:chairman:list  :主席用户列表
	 */
	_HT.on("voice:chairman:list", function(list){
		HTSDK.voice.voiceChairman.init(list);
	});
	
	/**
	 * @ 麦序事件
	 * voice:queue:reset    :麦序重设
	 * voice:queue:init    :麦序初始化
	 * voice:queue:list     :麦序列表
	 * voice:queue:change   :麦序列表变化
	 * voice:queue:join     :加入队列
	 * voice:queue:leave    :离开
	 * voice:queue:move     :移动
	 * voice:queue:clear    :清空
	 * voice:queue:control  :控制
	 * voice:queue:moveto   :移动到位置
	 * voice:queue:time     :队列时间
	 * voice:queue:countdown:倒计时
	 **/
	_HT.on("voice:queue:init", function(data){
		HTSDK.voice.voiceQueue.init(data);
	});

	/*_HT.on("voice:queue:list", function(list){
		HTSDK.voice.voiceQueue.list(list);
	});*/

	_HT.on("voice:queue:vlist", function(list){
		HTSDK.voice.voiceQueue.list(list);
	});

	_HT.on("voice:queue:control", function(obj){
		HTSDK.voice.voiceQueue.control(obj);
	});

	_HT.on("voice:queue:change", function(list){
		HTSDK.voice.voiceQueue.change(list);
	});

	_HT.on("voice:queue:leave", function(user){
	 	HTSDK.voice.voiceQueue.leave(user);
	});

	_HT.on("voice:queue:clear", function(user){
	 	HTSDK.voice.voiceQueue.clear(user);
	});

	_HT.on("voice:queue:join", function(user){
		HTSDK.voice.voiceQueue.join(user);
	});

	_HT.on("voice:queue:reset", function(list){
		HTSDK.voice.voiceQueue.reset(list);
	});

	_HT.on("voice:queue:countdown", function(sec){
		sec = parseInt(sec, 10);
		if(sec && sec > 0){
			$(".times_cont em").html(sec+"s");
		}else{
			$(".times_cont em").html("");
		}
	});

	 /**
	 * @ 举手事件
	 * voice:hand:reset  :举手列表初始化
	 * voice:hand:change :举手列表更改
	 * voice:hand:up     :举手
	 * voice:hand:leave  :离开
	 * voice:hand:allow  :允许
	 * voice:hand:forbid :禁止
	 * voice:hand:remove :移除
	 * voice:hand:clear  :清空
	 **/
	_HT.on("voice:hand:up", function(user){
		HTSDK.voice.voiceHand.join(user);
	});

	_HT.on("voice:hand:leave", function(user){
		HTSDK.voice.voiceHand.leave(user);
	});

	_HT.on("voice:hand:remove", function(user){
		HTSDK.voice.voiceHand._remove(user);
	});

	_HT.on("voice:hand:clear", function(){
		HTSDK.voice.voiceHand.clear();
	});

	_HT.on("voice:hand:reset", function(list){
		HTSDK.voice.voiceHand.reset(list);
	});

	_HT.on("voice:hand:allow", function(user){
		HTSDK.voice.voiceHand.allow(user);
	});

	_HT.on("voice:hand:forbid", function(user){
		HTSDK.voice.voiceHand.forbid(user);
	});

	_HT.on("voice:hand:change", function(list){
		HTSDK.voice.voiceHand.change(list);
	});
	// 语音云模块结束======> END


	// Room数据 所有操作完成
	// room:init success.
	// 房间初始化完成
	_HT.on("room:init", function(cb){
		//console.info(_HT);
		// 执行 HTSDK.init
		HTSDK.room.roomLoadSucess(_HT);
		// MTSDK.admin.init(_HT);
	});
};














